#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_PatientSpecialInstruction : BaseTest 
	{
		private BOL.PatientSpecialInstruction _tstPSI;
		private BOL.Patient _patient;

		private Guid _tstPSIGuid;
		private string _tstPSIs;
		private Guid _patientGuid;
		private DateTime _lastUpdateDate;
		

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		
			if (this.RefreshData)
			{
				string sSQL = "SELECT TOP 1 * FROM PatientSpecialInstruction WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'";

				DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(sSQL, true);

				
				_tstPSIGuid = (Guid) dtTemp.Rows[0][TABLES.PatientSpecialInstruction.PatientSpecialInstructionGuid];
				_tstPSIs	= dtTemp.Rows[0][TABLES.PatientSpecialInstruction.PatientSpecialInstructions].ToString();
				_patientGuid				= (Guid) dtTemp.Rows[0][TABLES.PatientSpecialInstruction.PatientGuid];
				_lastUpdateDate				= (DateTime) dtTemp.Rows[0][TABLES.PatientSpecialInstruction.LastUpdateDate];

				_patient = new BOL.Patient(_patientGuid);

				this.RefreshData = false;
			}

			_tstPSI = new BOL.PatientSpecialInstruction(_patient, _tstPSIs, UnitTestConfig.TestDivisionCode);
		}

		[Test]
		public void Ctor_Pass()
		{
			_tstPSI = new BOL.PatientSpecialInstruction(_patient, _tstPSIs, UnitTestConfig.TestDivisionCode);
			Assert.IsTrue(_tstPSI != null);
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void Ctor_Fail()
		{
			BOL.Patient patient = null;
			_tstPSI = new BOL.PatientSpecialInstruction(patient, _tstPSIs, UnitTestConfig.TestDivisionCode);
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			DataTable dt = BOL.PatientSpecialInstruction.GetSpecialInstructionsForPatient(this._patientGuid);
			DataRow [] dtRowArray = dt.Select("PatientSpecialInstructionGuid = '" + _tstPSIGuid + "'");
			DataRow dtRow = dtRowArray[0];
			_tstPSI = new BOL.PatientSpecialInstruction(dtRow);
			Assert.IsTrue(_tstPSI != null);
			if (dtRow.IsNull("PatientSpecialInstructions") == false)
			{
				Assert.AreEqual( (string)dtRow["PatientSpecialInstructions"], _tstPSIs);
			}
		}
		[Test]
		public void Ctor_DataRow_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = "XXX";
			DataTable dt = BOL.PatientSpecialInstruction.GetSpecialInstructionsForPatient(Guid.Empty);
			Assert.IsTrue(dt.Rows.Count==0);
		}
	
		[Test]
		public void PatientSpecialInstructionGuid_Pass()
		{
			Guid patientSpecialInstructionGuid = _tstPSI.PatientSpecialInstructionGuid;
			Assert.AreEqual(patientSpecialInstructionGuid, _tstPSI.PatientSpecialInstructionGuid);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientSpecialInstructionGuid_Fail()
		{
		}
	
		[Test]
		public void PatientSpecialInstructions_Pass()
		{
			string patientSpecialInstructions = _tstPSI.PatientSpecialInstructions;
			Assert.AreEqual(patientSpecialInstructions, this._tstPSIs);
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void PatientSpecialInstructions_Fail_Zero_Length()
		{
			_tstPSI.PatientSpecialInstructions = string.Empty;
		}
	
		[Test]
		public void CreateDate_Pass()
		{
			System.DateTime _CreateDate;
			_CreateDate = _tstPSI.CreateDate;
			Assert.AreEqual(_tstPSI.CreateDate,_CreateDate);
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void CreateDate_Fail()
		{
			_tstPSI.CreateDate = DateTime.MinValue;
		}

		[Test]
		public void CreateUser_Pass()
		{
			string createUser = _tstPSI.CreateUser;
			Assert.AreEqual(createUser, _tstPSI.CreateUser);
		}
	
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CreateUser_Fail()
		{
		}

		[Test]
		public void VistaConversionIndicator_Pass()
		{
			System.Boolean _VistaConversionIndicator;
			_VistaConversionIndicator = _tstPSI.VistaConversionIndicator;
			Assert.AreEqual(_tstPSI.VistaConversionIndicator,_VistaConversionIndicator);
		}


		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void VistaConversionIndicator_Fail()
		{
		}

		[Test]
		public void InactivationComment_Pass()
		{
			System.String _InactivationComment;
			_InactivationComment = _tstPSI.InactivationComment;
			Assert.AreEqual(_tstPSI.InactivationComment,_InactivationComment);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InactivationComment_Fail()
		{
		}

		[Test]
		public void InactivationDetails_Pass()
		{
			System.String _InactivationDetails;
			_InactivationDetails = _tstPSI.InactivationDetails;
			Assert.AreEqual(_tstPSI.InactivationDetails,_InactivationDetails);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InactivationDetails_Fail()
		{
		}

		[Test]
		public void InactivateDate_Pass()
		{
			System.DateTime _InactivateDate;
			_InactivateDate = _tstPSI.InactivateDate;
			Assert.AreEqual(_tstPSI.InactivateDate,_InactivateDate);
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void InactivateDate_Fail()
		{
			_tstPSI.InactivateDate = DateTime.MaxValue;
		}

		[Test]
		public void InactivateUser_Pass()
		{
			System.String _InactivateUser;
			_InactivateUser = _tstPSI.InactivateUser;
			Assert.AreEqual(_tstPSI.InactivateUser,_InactivateUser);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InactivateUser_Fail()
		{
		}

		[Test]
		public void DivisionCode_Pass()
		{
			System.String _DivisionCode;
			_DivisionCode = _tstPSI.DivisionCode;
			Assert.AreEqual(_tstPSI.DivisionCode,_DivisionCode);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DivisionCode_Fail()
		{
		}

		[Test]
		public void RecordStatusCode_Pass()
		{
			gov.va.med.vbecs.Common.RecordStatusCode _RecordStatusCode;
			_RecordStatusCode = _tstPSI.RecordStatusCode;
			Assert.AreEqual(_tstPSI.RecordStatusCode,_RecordStatusCode);
		}
	
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordStatusCode_Fail()
		{
		}

		[Test]
		public void GetSpecialInstructionsForPatient_Pass()
		{
			DataTable dt = BOL.PatientSpecialInstruction.GetSpecialInstructionsForPatient(this._patientGuid);
			Assert.IsTrue(dt.Rows.Count > 0);
		}
		[Test]
		public void GetSpecialInstructionsForPatient_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = "XXX";
			DataTable dt = BOL.PatientSpecialInstruction.GetSpecialInstructionsForPatient(Guid.Empty);
			Assert.IsTrue(dt.Rows.Count == 0);
		}

		[Test]
		public void InitializeSpecialInstructionsTable_Pass()
		{
			DataTable dt = BOL.PatientSpecialInstruction.InitializeSpecialInstructionsTable(true);
			foreach (DataColumn column in dt.Columns)
			{
				string columnName = column.ToString();
				if (
					columnName != TABLES.PatientSpecialInstruction.CreateDate &&
					columnName != TABLES.PatientSpecialInstruction.CreateUser &&
					columnName != TABLES.PatientSpecialInstruction.DivisionCode &&
					columnName != TABLES.PatientSpecialInstruction.InactivateDate &&
					columnName != TABLES.PatientSpecialInstruction.InactivateUser &&
					columnName != TABLES.PatientSpecialInstruction.InactivationComment &&
					columnName != TABLES.PatientSpecialInstruction.LastUpdateDate &&
					columnName != TABLES.PatientSpecialInstruction.LastUpdateUser &&
					columnName != TABLES.PatientSpecialInstruction.PatientGuid &&
					columnName != TABLES.PatientSpecialInstruction.PatientSpecialInstructionGuid &&
					columnName != TABLES.PatientSpecialInstruction.PatientSpecialInstructions &&
					columnName == TABLES.PatientSpecialInstruction.RecordStatusCode &&
					columnName == TABLES.PatientSpecialInstruction.RowVersion &&
					columnName == TABLES.PatientSpecialInstruction.VistaConversionIndicator
					)
				{
					Assert.Fail();
				}
			}
			Assert.IsTrue(true, "Yipee!");
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InitializeSpecialInstructionsTable_Fail()
		{
		}

				
		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow dr1 = new DataTable().NewRow();

			DataRow dr2 = this._tstPSI.LoadDataRowFromThis(dr1);

			Assert.AreEqual(dr1, dr2);
		}
				
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}
				
		[Test]
		public void SITextMatchesTR_Pass()
		{
			Random r = new Random();
			Assert.IsTrue(!BOL.PatientSpecialInstruction.SITextMatchesTR(r.Next(500).ToString()));
		}

			
		[Test]
		public void SITextMatchesTR_Fail()
		{
			// core text
			Assert.IsTrue(BOL.PatientSpecialInstruction.SITextMatchesTR("irradiat"));
			Assert.IsTrue(BOL.PatientSpecialInstruction.SITextMatchesTR("leukored "));
			Assert.IsTrue(BOL.PatientSpecialInstruction.SITextMatchesTR("leukocyte reduc"));
			Assert.IsTrue(BOL.PatientSpecialInstruction.SITextMatchesTR("wash "));
			Assert.IsTrue(BOL.PatientSpecialInstruction.SITextMatchesTR("sickle"));
			Assert.IsTrue(BOL.PatientSpecialInstruction.SITextMatchesTR("CMV"));

			// add other stuff
			Assert.IsTrue(BOL.PatientSpecialInstruction.SITextMatchesTR("irradiat  "));
			Assert.IsTrue(BOL.PatientSpecialInstruction.SITextMatchesTR("leukoredFOO"));
			Assert.IsTrue(BOL.PatientSpecialInstruction.SITextMatchesTR("leukocyte reduc FOO"));
			Assert.IsTrue(BOL.PatientSpecialInstruction.SITextMatchesTR("wash 111"));
			Assert.IsTrue(BOL.PatientSpecialInstruction.SITextMatchesTR("sickle !!!"));
			Assert.IsTrue(BOL.PatientSpecialInstruction.SITextMatchesTR("CMV +1"));
		}	

		[Test]
		public void DoActiveSpecialInstructionsExistForPatient_Pass()
		{
			DataRow dr = UnitTestUtil.RunSQLGetDataRow( "SELECT TOP 1 PatientGuid FROM PatientSpecialInstruction" );
			//
			Guid patientGuid = (Guid)dr[TABLES.PatientSpecialInstruction.PatientGuid];
			//
			bool exist = BOL.PatientSpecialInstruction.DoActiveSpecialInstructionsExistForPatient( patientGuid );
			//
			Assert.IsTrue( exist );
			//
			dr = UnitTestUtil.RunSQLGetDataRow( "SELECT TOP 1 PatientGuid FROM Patient WHERE PatientGuid NOT IN (SELECT PatientGuid FROM PatientSpecialInstruction)" );
			//
			patientGuid = (Guid)dr[TABLES.PatientSpecialInstruction.PatientGuid];
			//
			exist = BOL.PatientSpecialInstruction.DoActiveSpecialInstructionsExistForPatient( patientGuid );
			//
			Assert.IsTrue( !exist );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DoActiveSpecialInstructionsExistForPatient_Fail()
		{
		}
	}
}

#endif

